
IF OBJECT_ID('P_EST_PROD_CPL_ESTOQUE_TELEVENDAS') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_EST_PROD_CPL_ESTOQUE_TELEVENDAS;
    END;

GO


CREATE PROCEDURE P_EST_PROD_CPL_ESTOQUE_TELEVENDAS @CD_EMP    INT,
                                                   @CD_FILIAL INT,
                                                   @CD_PROD   INT
AS
set nocount on;

     DECLARE @FLAG_MOSTRA_ESTOQUE INT;
     DECLARE @FLAG_MOSTRA_ESTOQUE_DEPOSITO INT;
	 DECLARE @FLAG_MOSTRA_ESTOQUE_TODOS_GRUPO_ECONOMICO INT;
	 DECLARE @CD_GRP_ECON_FILIAL INT;

     CREATE TABLE #RsRetorno (CD_FILIAL INT,
						  FILIAL    VARCHAR(10),
						  ESTOQUE   VARCHAR(25),
						  GRUPO     VARCHAR(50),
						  CD_GRP_ECON INT);

     SET @FLAG_MOSTRA_ESTOQUE = ISNULL((SELECT ISNULL(VALOR, 0) FROM PRC_EMP_CONFIG
                                        WHERE CD_CHAVE = 'FLAG_MOSTRA_ESTOQUE_FILIAL'), 0);

     SET @FLAG_MOSTRA_ESTOQUE_DEPOSITO = ISNULL((SELECT ISNULL(VALOR, 0) FROM PRC_EMP_CONFIG
                                                WHERE CD_CHAVE = 'ORC_TELE_MOSTRA_ESTOQUE_DEPOSITO'), 0);

    SET @FLAG_MOSTRA_ESTOQUE_TODOS_GRUPO_ECONOMICO = ISNULL((SELECT ISNULL(VALOR, 0) FROM PRC_EMP_CONFIG
                                                WHERE CD_CHAVE = 'MOSTRA_ESTOQUE_TODOS_GRUPO_ECONOMICO'), 0);

	 SET @CD_GRP_ECON_FILIAL = COALESCE((	SELECT TOP 1 CD_GRP_ECON
										  FROM PRC_GRP_ECON_PRC_FILIAL
										  WHERE 
										  CD_EMP = @CD_EMP
										  AND CD_FILIAL = @CD_FILIAL), 0);

	   INSERT INTO #RsRetorno
            SELECT 
			 EST_PROD_CPL.CD_FILIAL,
			 right('0000' + CONVERT(VARCHAR(4), EST_PROD_CPL.CD_FILIAL),4) Filial,
			 CONVERT(INT, EST_PROD_CPL.QT_EST) 'Estoque',
			 PRC_GRP_ECON.NM_GRP_ECON 'Grupo',
			 PRC_GRP_ECON.CD_GRP_ECON
            FROM 
			 EST_PROD_CPL
			 LEFT JOIN PRC_FILIAL ON 
			 EST_PROD_CPL.CD_EMP = PRC_FILIAL.CD_EMP AND 
			 EST_PROD_CPL.CD_FILIAL = PRC_FILIAL.CD_FILIAL
                 
			 LEFT JOIN PRC_GRP_ECON_PRC_FILIAL ON 
			 PRC_FILIAL.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND 
			 PRC_FILIAL.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

			 LEFT JOIN PRC_GRP_ECON ON 
			 PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON = PRC_GRP_ECON.CD_GRP_ECON
                 
			 INNER JOIN PRC_REGIAO_FISCAL_PRC_FILIAL ON 
			 EST_PROD_CPL.CD_EMP = PRC_REGIAO_FISCAL_PRC_FILIAL.CD_EMP AND 
			 EST_PROD_CPL.CD_FILIAL = PRC_REGIAO_FISCAL_PRC_FILIAL.CD_FILIAL
            WHERE 
			 EST_PROD_CPL.CD_EMP = 1
			 AND EST_PROD_CPL.QT_EST > 0
			 AND EST_PROD_CPL.CD_PROD = @CD_PROD;


	IF @FLAG_MOSTRA_ESTOQUE = 0
	BEGIN

	DELETE d
	   from 
		  #RsRetorno d
	WHERE 
		d.CD_FILIAL <> @CD_FILIAL
		AND NOT EXISTS (SELECT DEP.CD_FILIAL FROM PRC_FILIAL_DEPOSITO DEP 
						  JOIN PRC_FILIAL_DEPOSITO_PRC_FILIAL FILIAL ON 
						  FILIAL.CD_CTR_DEPO   = DEP.CD_CTR_DEPO AND 
						  FILIAL.CD_EMP	    = DEP.CD_EMP
						WHERE 
						  FILIAL.CD_FILIAL = @CD_FILIAL
						  AND
						  d.cd_filial = dep.cd_filial) --Controle do deposito será feito posterirmente na query seguinte.
		AND d.CD_GRP_ECON = @CD_GRP_ECON_FILIAL --Controle do GRUPO ECONOMICO será feito posterirmente.

	END


    IF @FLAG_MOSTRA_ESTOQUE_DEPOSITO = 0
    BEGIN
	   DELETE d
	   from 
		  #RsRetorno d
		  join PRC_FILIAL_DEPOSITO DEP on
		  d.cd_filial = dep.cd_filial
		  JOIN PRC_FILIAL_DEPOSITO_PRC_FILIAL FILIAL ON 
		  FILIAL.CD_CTR_DEPO   = DEP.CD_CTR_DEPO AND 
		  FILIAL.CD_EMP	    = DEP.CD_EMP
        WHERE 
		  FILIAL.CD_FILIAL = @CD_FILIAL;
    END;

	IF @FLAG_MOSTRA_ESTOQUE_TODOS_GRUPO_ECONOMICO = 0
	BEGIN
		 DELETE d
	   from 
		  #RsRetorno d WHERE d.CD_GRP_ECON <> @CD_GRP_ECON_FILIAL
	END
	

    SELECT 
	   FILIAL AS 'Filial',
        ESTOQUE AS 'Estoque',
        GRUPO	 AS 'Grupo'
    FROM #RsRetorno;
    
    DROP TABLE #RsRetorno; 